/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.model.Logo1;
import DE.siemens.ad.logo.model.visitor.build.CompilerFromHardware;
import DE.siemens.ad.logo.model.visitor.build.CompilerFromLogo2;
import DE.siemens.ad.logo.model.visitor.build.LinkerToLogo;
import DE.siemens.ad.logo.model.visitor.build.LinkerToLogo2;
import DE.siemens.ad.logo.util.AnchorMemory8;
import DE.siemens.ad.logo.util.Memory;
import DE.siemens.ad.logo.util.MessageMemory8;
import DE.siemens.ad.logo.util.ParameterMemory8;
import DE.siemens.ad.logo.util.ProgramMemory8;
import java.io.ByteArrayOutputStream;

public abstract class Logo2
extends Logo1 {
    static final long serialVersionUID = 5452022563100257970L;
    private int logo1SerializedDataVersion = 1;

    public void downloadProgramName(DataTransfer dt) throws TransmissionFailedException {
        int MAX_LENGTH = 16;
        String prjName = this.fDownloadedWiringDiagram.getDrawingProperties().getProgramName();
        byte[] byteArr = prjName.getBytes();
        int[] prjNameArr = new int[16];
        for (int i = 0; i < 16; ++i) {
            prjNameArr[i] = i < byteArr.length ? byteArr[i] : 32;
        }
        dt.writeByteArray(this.getAdress(ADR_PROGRAM_NAME), prjNameArr);
    }

    public Memory[] getMemories() {
        if (this.fMemories == null) {
            this.fMemories = new Memory[7];
            this.fMemories[0] = new ProgramMemory8(64312, this.getMaxResource(0));
            this.fMemories[1] = new ParameterMemory8(64592, this.getMaxResource(3));
            this.fMemories[2] = new AnchorMemory8(64272, 2, 216);
            this.fMemories[3] = new AnchorMemory8("ASi-Anker", 64292, 1, 236);
            this.fMemories[4] = new AnchorMemory8("Merker", 64282, 2, 224);
            this.fMemories[5] = new AnchorMemory8("Reserviert", 64297, 3, 240);
            this.fMemories[6] = new MessageMemory8("Meldetext", 256, 20);
        }
        return this.fMemories;
    }

    public int getNumberOfTransferBytes() {
        return 722;
    }

    protected String uploadProgramName(DataTransfer dt) throws TransmissionFailedException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(16);
        int[] intArr = dt.readByteArray(this.getAdress(ADR_PROGRAM_NAME), 16);
        for (int i = 0; i < intArr.length && intArr[i] != 0; ++i) {
            buffer.write(intArr[i]);
        }
        return buffer.toString();
    }

    public int getAdress(int name) {
        if (name == ADR_PROGRAM_NAME) {
            return 496;
        }
        return super.getAdress(name);
    }

    public CompilerFromHardware getCompilerFromHardware() {
        return new CompilerFromLogo2();
    }

    public LinkerToLogo getLinkerToHardware() {
        return new LinkerToLogo2(this);
    }
}

